<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Login</title>
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
    <link rel="icon" type="image/png" href="../assets/img/favicon.png" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
<link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">    
<link rel="manifest" href="../assets/scripts/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
<link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
<link rel="icon" type="image/png" href="../../assets/img/favicon.png" />
<?php if(isset($_SESSION['loginId'])){echo "<script>window.location.href='../home/';</script>"; } ?>
<style>
    
    
        body{background:linear-gradient(#000099,#3333ff); background-image:url("../../assets/img/bg/cover7.jpg");   background-position:center center;-webkit-background-size:cover;-moz-background-size:cover;
            background-size:cover;-o-background-size:cover;background-repeat:no-repeat;background-attachment:fixed}
            #loginContainerContent{margin-top:20vh;margin-bottom:10px;text-align:left;color:#000;font-weight:600;}
            .brand_logo_container{margin-top:-120px; margin-bottom: 20px; padding:10px;}
            .brand_logo{height:150px;width:155px;text-align:center;}
            .position{max-width:400px;height:auto;margin:auto;position:relative}
            .user_card{
                background:rgba(255,255,255,0.9); padding:30px;  
                box-shadow:0 4px 8px 0 rgba(0,0,0,.2),0 6px 20px 0 rgba(0,0,0,.19);
                -webkit-box-shadow:0 4px 8px 0 rgba(0,0,0,.2),0 6px 20px 0 rgba(0,0,0,.19);
                -moz-box-shadow:0 4px 8px 0 rgba(0,0,0,.2),0 6px 20px 0 rgba(0,0,0,.19);
                border-radius:2rem; color:#000;
            }
                h3{color:#000;text-align:left;font-weight:600}
                .loginbtn{border-radius:1rem;}
                .form-control{border-radius:1rem;}
            #pindiv{display:none;}
    </style>
</head>

<body >

<div class="container">
<div id="loginContainerContent">
            <div  class="position user_card">
            <div>
                <div align="center" class="brand_logo_container"><img src="../../assets/img/login.png" alt="Logo" class="brand_logo" /></div>
                <h5 class="text-center"><b id="accountname">Welcome Back</b></h5>
                <hr/>
                <form id="login-form" method="post">
                    <div class="text-center">
                    
                        <div class="form-group mb-3" id="phonediv">
                        
                        <input type="number" name="phone"  maxlength="50" class="form-control" id="phonelogin" placeholder="Number" required />
                        </div>
                        
                        <div class="form-group mb-3">
                        <input type="password" name="password" maxlength="50" class="form-control" placeholder="Password" required />
                        </div>
                                            
                    <div class="form-group">            
                        <button class="btn loginbtn btn-primary btn-lg btn-block" type="submit" name="login" id="loginbtn"><i class="fa fa-sign-in" aria-hidden="true"></i> Login</button>               
                    </div>
                    <div class="row pt-5 mb-3">
                        <div class="btn col-12 text-center font-15">
                            <a class="text-black" href="../recovery/">Forget Password? Recover It</a> 
                        </div>
                        <div class="btn col-12 text-center font-15 mt-2">
                            <a class="text-black" href="../register/">New User? Create Account</a>
                        </div>               
                    </div>  
                    
                </form>
    </div>
    </div>
</div>
</div>
    

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script type="text/javascript">
    $("document").ready(function(){

        //Save Phone Number
        checkIfPhoneNumberSaved();

        //Enable Form Input
        $("#phonelogin").click(function(){$(this).removeAttr("readonly"); });
        $("#passwordlogin").click(function(){$(this).removeAttr("readonly"); });

        //Registration Form
        $('#login-form').submit(function(e){
                e.preventDefault()
                $('#loginbtn').removeClass("btn-primary");
                $('#loginbtn').addClass("btn-secondary");
                $('#loginbtn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');
                
                $.ajax({
                    url:'../home/includes/route.php?login',
                    data: new FormData($(this)[0]),
                    cache: false,
                    contentType: false,
                    processData: false,
                    method: 'POST',
                    type: 'POST',
                    success:function(resp){
                        
                        resp = JSON.parse(resp);

                        if(resp.status == "success"){
                            swal('Alert!!',"Login Succesfull","success");
                            setTimeout(function(){
                                location.replace('../home/')
                            },1000)
                        }
                        else{
                            swal('Alert!!',resp.msg,"error");
                        }

                    $('#loginbtn').removeClass("btn-secondary");
                    $('#loginbtn').addClass("btn-primary");
                    $('#loginbtn').html("<b>Login</b>");

                    }
                })
            });

    });

    function checkIfPhoneNumberSaved() {
        $phone = atob(unescape(getCookie("loginPhone")));
        $name = atob(unescape(getCookie("loginName")));
        if($phone != null && $phone != ""){
            let msg='<p class="mb-3"><a href="javascript:showNumber();"><b class="text-primary">Login With Another Account?</b></a></p>';
            $("#accountname").after(msg);
            $("#accountname").append(" "+$name+"!");
            $("#phonediv").hide();
            $("#phonelogin").val($phone);
        }
    }

    function showNumber(){
        $("#phonediv").show();
    }
     
    function getCookie(cname) {
        var name = cname + "=";
        var ca = document.cookie.split(';');
        for(var i=0; i<ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1);
            if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
        }
        return "";
    }

</script>

    
</body>
</html>