<!DOCTYPE HTML>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Sihpay Register</title>

  <link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
  <link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">
  <link rel="icon" type="image/png" href="../../assets/img/favicon.png" />

  <style>
    body {
      font-family: 'Inter', sans-serif;
      background: #0f1116;
      color: #fff;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
      transition: background 0.3s, color 0.3s;
    }

    .register-container {
      width: 100%;
      max-width: 420px;
      padding: 28px;
      background: #1a1d25;
      border-radius: 16px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.6);
      overflow: auto;
      max-height: 94vh;
      transition: background 0.3s, color 0.3s;
      position: relative;
    }

    .theme-toggle {
      position: absolute;
      top: 14px;
      right: 14px;
      background: none;
      border: none;
      cursor: pointer;
      font-size: 18px;
      color: #fff;
      transition: color 0.3s;
    }

    .register-logo {
      text-align: center;
      margin-bottom: 16px;
      margin-top: 18px;
    }

    .register-logo img { width: 66px; margin-bottom: 8px; }
    .register-logo h1 { font-size: 20px; margin: 0; color: #fff; }
    .register-logo p { color: #9aa0a6; margin: 6px 0 14px; }

    .progress-steps { display: flex; gap: 8px; margin-bottom: 20px; align-items: center; }
    .progress-steps .step {
      flex: 1; text-align: center; color: #9aa0a6; font-size: 13px; position: relative;
    }
    .progress-steps .step::before {
      content:''; display:block; width:20px; height:20px; border-radius:50%;
      background:#333842; margin:0 auto 8px; transition:background .18s;
    }
    .progress-steps .step.active { color:#ffffff; font-weight:600; }
    .progress-steps .step.active::before { background:#ffffff; }
    .progress-steps .step::after {
      content:''; position:absolute; top:10px; left:50%; width:100%; height:2px;
      background:#333842; z-index:-1;
    }
    .progress-steps .step:last-child::after{display:none;}

    .input-style { position: relative; margin-bottom: 16px; }
    .form-control {
      background: #222630;
      border: 1px solid #333842;
      border-radius: 12px;
      padding: 14px 44px 14px 14px;
      color: #fff;
      transition: background 0.3s, color 0.3s, border 0.3s;
    }
    .form-control::placeholder { color: #9aa0a6; }
    .input-style i {
      position: absolute; right: 14px; top: 50%; transform: translateY(-50%);
      color: #aab0b6;
    }
    .form-control:focus {
      outline: none;
      border-color: <?php echo $sitecolor; ?>;
      box-shadow: 0 0 8px <?php echo $sitecolor; ?>33;
    }

    .btn-register {
      width: 100%;
      padding: 13px;
      border-radius: 12px;
      background: linear-gradient(135deg, <?php echo $sitecolor; ?>, <?php echo $sitecolor; ?>cc);
      border: none;
      color: #fff;
      font-weight: 600;
      transition: background 0.3s, color 0.3s;
    }

    .btn-secondary { background: #6c6f76 !important; color: #fff !important; }
    .gradient-highlight { background: linear-gradient(135deg, <?php echo $sitecolor; ?>, <?php echo $sitecolor; ?>cc); color: #fff; }

    .small-link { margin-top: 12px; text-align: center; }
    .small-link a {
      color: <?php echo $sitecolor; ?>;
      text-decoration: none;
      font-weight: 500;
      transition: color 0.3s;
    }

    #toast {
      visibility: hidden;
      min-width: 220px;
      max-width: 90%;
      background: #111;
      color: #fff;
      text-align: center;
      border-radius: 8px;
      padding: 12px 16px;
      position: fixed;
      z-index: 9999;
      left: 50%;
      bottom: 30px;
      transform: translateX(-50%);
      font-size: 14px;
      font-weight: 500;
      opacity: 0;
      transition: opacity .3s, bottom .3s;
    }
    #toast.show { visibility: visible; opacity: 1; bottom: 50px; }

    @media(max-width:480px){ .register-container { padding: 20px; margin: 0 12px; } }

    /* ------------------- LIGHT MODE ------------------- */
    body.light-mode { background: #f9f9f9; color: #111; }
    .light-mode .register-container { background: #fff; box-shadow: 0 8px 24px rgba(0,0,0,0.08); }
    .light-mode .register-logo h1 { color: #111; }
    .light-mode .register-logo p { color: #555; }
    .light-mode .form-control {
      background: #f2f2f2;
      color: #000;
      border-color: #ddd;
    }
    .light-mode .input-style i { color: #888; }
    .light-mode .btn-register { color: #000; } /* visible black text */
    .light-mode .small-link a { color: #111; }
    .light-mode .theme-toggle { color: #111; }
  </style>
</head>

<body>
  <div class="register-container">
    <button class="theme-toggle" id="themeToggle"><i class="fa fa-moon"></i></button>

    <div class="register-logo">
      <img src="../../assets/img/favicon.png" alt="Logo">
      <h1><?php echo $sitename; ?></h1>
      <p>Create your account</p>
    </div>

    <div class="progress-steps">
      <div class="step active">Personal Info</div>
      <div class="step">Security</div>
    </div>

    <form id="reg-form" method="post" enctype="multipart/form-data">
      <div id="regDiv">
        <div class="input-style">
          <input type="text" class="form-control" id="fname" name="fname" placeholder="First Name" required>
          <i class="fa fa-user"></i>
        </div>

        <div class="input-style">
          <input type="text" class="form-control" id="lname" name="lname" placeholder="Last Name" required>
          <i class="fa fa-user"></i>
        </div>

        <div class="input-style">
          <input type="number" class="form-control" id="phone" name="phone" placeholder="Phone" required readonly>
          <i class="fa fa-phone"></i>
        </div>

        <div class="input-style">
          <input type="email" class="form-control" id="email" name="email" placeholder="Email" readonly>
          <i class="fa fa-envelope"></i>
        </div>

        <input id="account" name="account" type="hidden" value="1" />
        <a id="next-btn" class="btn-register gradient-highlight" style="display:block;text-align:center">Continue</a>
      </div>

      <div id="nextregDiv" style="display:none">
        <div class="input-style">
          <select class="form-control" id="state" name="state" required>
            <option value="">Select State</option>
            <option>Abia</option><option>Adamawa</option><option>Akwa Ibom</option><option>Anambra</option>
            <option>Bauchi</option><option>Bayelsa</option><option>Benue</option><option>Borno</option>
            <option>Cross River</option><option>Delta</option><option>Ebonyi</option><option>Edo</option>
            <option>Ekiti</option><option>Enugu</option><option>FCT - Abuja</option><option>Gombe</option>
            <option>Imo</option><option>Jigawa</option><option>Kaduna</option><option>Kano</option>
            <option>Katsina</option><option>Kebbi</option><option>Kogi</option><option>Kwara</option>
            <option>Lagos</option><option>Nasarawa</option><option>Niger</option><option>Ogun</option>
            <option>Ondo</option><option>Osun</option><option>Oyo</option><option>Plateau</option>
            <option>Rivers</option><option>Sokoto</option><option>Taraba</option><option>Yobe</option>
            <option>Zamfara</option>
          </select>
          <i class="fa fa-map-marker-alt"></i>
        </div>

        <div class="input-style">
          <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
          <i class="fa fa-lock"></i>
        </div>

        <div class="input-style">
          <input type="password" class="form-control" id="cpassword" name="cpassword" placeholder="Confirm Password" required>
          <i class="fa fa-lock"></i>
        </div>

        <div class="input-style">
          <input type="number" class="form-control" id="transpin" name="transpin" placeholder="4 Digit Pin" required>
          <i class="fa fa-key"></i>
        </div>

        <input type="hidden" value="" id="referal" name="referal" />
        <button type="submit" id="submit-btn" class="btn-register gradient-highlight">Register</button>
      </div>
    </form>

    <div class="small-link">
      <a href="../login/">Already have an account? Login</a>
    </div>
  </div>

  <div id="toast"></div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    function showToast(message, timeout = 2600) {
      const t = document.getElementById('toast');
      t.innerText = message;
      t.className = 'show';
      clearTimeout(t._t);
      t._t = setTimeout(() => { t.className = t.className.replace('show',''); }, timeout);
    }

    $(document).ready(function(){
      $("#email, #phone, #password, #cpassword").click(function(){ $(this).removeAttr("readonly"); });

      $("#next-btn").click(function(){
        let $msg = "";
        $('#next-btn').removeClass('gradient-highlight').addClass('btn-secondary').html('<i class="fa fa-spinner fa-spin"></i> Processing ...');
        if($("#fname").val() == "") $msg = "Please Enter First Name.";
        else if($("#lname").val() == "") $msg = "Please Enter Last Name.";
        else if($("#phone").val() == "") $msg = "Please Enter Phone Number.";
        else if($("#email").val() == "") $msg = "Please Enter Email.";

        if($msg != ""){
          showToast($msg, 3000);
          $('#next-btn').removeClass('btn-secondary').addClass('gradient-highlight').html('Continue');
          return;
        }
        $("#regDiv").hide(); $("#nextregDiv").show();
        $(".progress-steps .step").removeClass("active");
        $(".progress-steps .step:nth-child(2)").addClass("active");
      });

      $('#reg-form').submit(function(e){
        e.preventDefault();
        let $msg = "";
        if($("#password").val().length < 8) $msg = "Password should be at least 8 characters.";
        else if($("#password").val().length > 15) $msg = "Password should not exceed 15 characters.";
        else if($("#password").val() == $("#phone").val()) $msg = "You can't use your phone number as password.";
        else if($("#password").val() != $("#cpassword").val()) $msg = "Password mismatch.";
        else if($("#state").val() == "") $msg = "Please Select State.";
        else if(String($("#transpin").val()).length != 4) $msg = "Please enter a 4 digit pin";

        if($msg != ""){
          showToast($msg, 3000);
          return;
        }

        $('#submit-btn').removeClass('gradient-highlight').addClass('btn-secondary').html('<i class="fa fa-spinner fa-spin"></i> Processing ...');
        $.ajax({
          url: '../home/includes/route.php?register',
          data: new FormData($(this)[0]),
          cache: false,
          contentType: false,
          processData: false,
          method: 'POST',
          success: function(resp){
            try { resp = JSON.parse(resp); } catch (e) { resp = { status: 'error', msg: 'Invalid server response' }; }
            if(resp.status == "success"){
              showToast("Registration Successful — redirecting...", 1600);
              setTimeout(()=> location.replace('../home/'), 1200);
            } else {
              showToast("Registration failed: " + (resp.msg || 'Unknown error'), 4000);
              $("#nextregDiv").hide(); $("#regDiv").show();
              $(".progress-steps .step").removeClass("active");
              $(".progress-steps .step:nth-child(1)").addClass("active");
            }
            $('#submit-btn').removeClass('btn-secondary').addClass('gradient-highlight').html('Register');
            $('#next-btn').removeClass('btn-secondary').addClass('gradient-highlight').html('Continue');
          },
          error: function(){
            showToast("Error: Unable to connect to server", 3000);
            $('#submit-btn').removeClass('btn-secondary').addClass('gradient-highlight').html('Register');
          }
        });
      });

      // Theme Toggle
      const toggle = document.getElementById('themeToggle');
      toggle.addEventListener('click', () => {
        document.body.classList.toggle('light-mode');
        const icon = toggle.querySelector('i');
        if(document.body.classList.contains('light-mode')){
          icon.classList.remove('fa-moon');
          icon.classList.add('fa-sun');
        } else {
          icon.classList.remove('fa-sun');
          icon.classList.add('fa-moon');
        }
      });
    });
  </script>
</body>
</html>