<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<title>Register</title>
<link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
<link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">    
<link rel="manifest" href="../assets/scripts/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
<link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
<link rel="icon" type="image/png" href="../../assets/img/favicon.png" />
<style>
    body {
        background-image: url("../../assets/img/bg.jpg");
        background-repeat: no-repeat;
        background-size: cover;
        font-family: 'Inter', sans-serif;
    }
    .card {
        background-color: rgba(255, 255, 255, 0.85);
        border-radius: 1rem;
        padding: 30px;
        margin-top: 20px;
        max-width: 400px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .form-control {
        background-color: #fafafa;
        border-radius: 3rem;
        padding-left: 50px;
    }
    .form-control:focus {
        background-color: #ffffff;
    }
    .input-style i {
        padding-left: 20px;
    }
    .btn {
        border-radius: 3rem;
    }
    h1 {
        font-size: 1.8rem;
        color: #333;
    }
    p {
        color: #666;
    }
    .text-center {
        color: #333;
    }
</style>
</head>

<body class="theme-light">
<div id="page">
    <div class="page-content mt-5">
        <div style="display:flex; justify-content:center; align-items:center;">
            <div class="card">
                <div class="text-center mb-4">
                    <h1>Register</h1>
                    <p>Create your free account</p>
                </div>
                
                <form id="reg-form" method="post">
                    <div class="input-style no-borders has-icon mb-4">
                        <i class="fa fa-user"></i>
                        <input type="text" class="form-control" id="fname" name="fname" placeholder="First Name" required />
                    </div>

                    <div class="input-style no-borders has-icon mb-4">
                        <i class="fa fa-user"></i>
                        <input type="text" class="form-control" id="lname" name="lname" placeholder="Last Name" required />
                    </div>

                    <div class="input-style no-borders has-icon mb-4">
                        <i class="fa fa-phone"></i>
                        <input type="number" class="form-control" id="phone" name="phone" placeholder="Phone" required readonly />
                    </div>

                    <div class="input-style no-borders has-icon mb-4">
                        <i class="fa fa-at"></i>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" readonly />
                    </div>

                    <div class="input-style no-borders has-icon mb-4">
                        <i class="fa fa-lock"></i>
                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required readonly />
                    </div>

                    <div class="input-style no-borders has-icon mb-4">
                        <i class="fa fa-lock"></i>
                        <input type="password" class="form-control" id="cpassword" name="cpassword" placeholder="Confirm Password" required readonly />
                    </div>

                    <button type="submit" id="submit-btn" class="btn btn-primary btn-block font-600 font-15 gradient-highlight mt-4 rounded-s">
                        Register
                    </button>

                    <div class="text-center mt-4">
                        <a href="../login/" class="text-primary">Already have an account? <b>Login Now</b></a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="../assets/scripts/bootstrap.min.js"></script>
<script src="../assets/scripts/custom.js"></script>
</body>
</html>